/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.hdriver.impl.execute;

import com.alibaba.druid.hdriver.impl.HBaseConnectionImpl;
import com.alibaba.druid.hdriver.impl.HPreparedStatementImpl;
import com.alibaba.druid.hdriver.impl.HResultSetMetaDataImpl;
import com.alibaba.druid.hdriver.impl.HScannerResultSetImpl;
import com.alibaba.druid.hdriver.impl.execute.SingleTableExecutePlan;
import com.alibaba.druid.hdriver.impl.mapping.HMapping;
import com.alibaba.druid.hdriver.impl.mapping.HMappingDefaultImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;

public class SingleTableQueryExecutePlan
extends SingleTableExecutePlan {
    private List<String> columeNames = new ArrayList<String>();
    private List<SQLExpr> conditions = new ArrayList<SQLExpr>();
    private HResultSetMetaDataImpl resultMetaData;
    private String dbType = "hbase";
    private Scan scan;
    private HPreparedStatementImpl statement;

    public List<SQLExpr> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<SQLExpr> conditions) {
        this.conditions = conditions;
    }

    public List<String> getColumeNames() {
        return this.columeNames;
    }

    public HResultSetMetaDataImpl getResultMetaData() {
        return this.resultMetaData;
    }

    public void setResultMetaData(HResultSetMetaDataImpl resultMetaData) {
        this.resultMetaData = resultMetaData;
    }

    @Override
    public HScannerResultSetImpl executeQuery(HPreparedStatementImpl statement) throws SQLException {
        try {
            HMapping mapping = this.getMapping();
            if (mapping == null) {
                mapping = new HMappingDefaultImpl();
            }
            HBaseConnectionImpl connection = statement.getConnection();
            this.scan = new Scan();
            this.statement = statement;
            Filter filter = null;
            for (SQLExpr item : this.conditions) {
                SQLBinaryOpExpr condition = (SQLBinaryOpExpr)item;
                filter = this.setFilter(condition, filter, true);
            }
            if (filter != null) {
                this.scan.setFilter(filter);
            }
            HTableInterface htable = connection.getHTable(this.getTableName());
            ResultScanner scanner = htable.getScanner(this.scan);
            HScannerResultSetImpl resultSet = new HScannerResultSetImpl(statement, htable, scanner);
            resultSet.setMetaData(this.resultMetaData);
            HScannerResultSetImpl hScannerResultSetImpl = resultSet;
            return hScannerResultSetImpl;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("executeQuery error", e);
        }
        finally {
            this.scan = null;
            this.statement = null;
        }
    }

    private Filter setFilter(SQLBinaryOpExpr condition, Filter filter, boolean and) throws IOException, SQLException {
        HMapping mapping = this.getMapping();
        if (condition.getOperator() == SQLBinaryOperator.BooleanAnd) {
            filter = this.setFilter((SQLBinaryOpExpr)condition.getLeft(), filter, true);
            filter = this.setFilter((SQLBinaryOpExpr)condition.getRight(), filter, true);
            return filter;
        }
        if (condition.getOperator() == SQLBinaryOperator.BooleanOr) {
            filter = this.setFilter((SQLBinaryOpExpr)condition.getLeft(), filter, false);
            filter = this.setFilter((SQLBinaryOpExpr)condition.getRight(), filter, false);
            return filter;
        }
        String fieldName = ((SQLIdentifierExpr)condition.getLeft()).getName();
        Object value = SQLEvalVisitorUtils.eval(this.dbType, (SQLObject)condition.getRight(), this.statement.getParameters());
        byte[] bytes = mapping.toBytes(fieldName, value);
        if (mapping.isRow(fieldName)) {
            if (filter == null && condition.getOperator() == SQLBinaryOperator.GreaterThanOrEqual) {
                this.scan.setStartRow(bytes);
                return null;
            }
            if (filter == null && condition.getOperator() == SQLBinaryOperator.LessThan) {
                this.scan.setStopRow(bytes);
                return null;
            }
            CompareFilter.CompareOp compareOp = this.toCompareOp(condition.getOperator());
            RowFilter rowFilter = new RowFilter(compareOp, (WritableByteArrayComparable)new BinaryComparator(bytes));
            return this.setFilter(filter, (Filter)rowFilter, and);
        }
        byte[] qualifier = mapping.getQualifier(fieldName);
        byte[] family = mapping.getFamily(fieldName);
        CompareFilter.CompareOp compareOp = this.toCompareOp(condition.getOperator());
        SingleColumnValueFilter columnFilter = new SingleColumnValueFilter(family, qualifier, compareOp, bytes);
        return this.setFilter(filter, (Filter)columnFilter, and);
    }

    CompareFilter.CompareOp toCompareOp(SQLBinaryOperator operator) {
        switch (operator) {
            case Equality: {
                return CompareFilter.CompareOp.EQUAL;
            }
            case NotEqual: {
                return CompareFilter.CompareOp.NOT_EQUAL;
            }
            case GreaterThan: {
                return CompareFilter.CompareOp.GREATER;
            }
            case GreaterThanOrEqual: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case LessThan: {
                return CompareFilter.CompareOp.LESS;
            }
            case LessThanOrEqual: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
        }
        throw new UnsupportedOperationException("TODO");
    }

    Filter setFilter(Filter parentFilter, Filter filter, boolean and) {
        if (parentFilter == null) {
            return filter;
        }
        if (parentFilter instanceof FilterList) {
            FilterList filterList = (FilterList)parentFilter;
            if (and) {
                if (filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL) {
                    filterList.addFilter(filter);
                    return filterList;
                }
                return new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{parentFilter, filter});
            }
            if (filterList.getOperator() == FilterList.Operator.MUST_PASS_ONE) {
                filterList.addFilter(filter);
                return filterList;
            }
            return new FilterList(FilterList.Operator.MUST_PASS_ONE, new Filter[]{parentFilter, filter});
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(parentFilter);
        filters.add(filter);
        FilterList.Operator filterOp = and ? FilterList.Operator.MUST_PASS_ALL : FilterList.Operator.MUST_PASS_ONE;
        return new FilterList(filterOp, filters);
    }
}

