/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.hdriver.impl.execute;

import com.alibaba.druid.hdriver.HResultSet;
import com.alibaba.druid.hdriver.HStatement;
import com.alibaba.druid.hdriver.impl.HPreparedStatementImpl;
import com.alibaba.druid.hdriver.impl.HResultSetMetaDataImpl;
import com.alibaba.druid.hdriver.impl.execute.ExecutePlan;
import com.alibaba.druid.util.jdbc.ResultSetBase;
import com.alibaba.druid.util.jdbc.ResultSetMetaDataBase;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class ShowTablesPlan
implements ExecutePlan {
    @Override
    public HResultSet executeQuery(HPreparedStatementImpl statement) throws SQLException {
        try {
            HBaseAdmin admin = statement.getConnection().getEngine().getHBaseAdmin();
            HTableDescriptor[] tables = admin.listTables();
            return new ShowTableResultSet(statement, tables);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("executeQuery error", e);
        }
    }

    @Override
    public boolean execute(HPreparedStatementImpl statement) throws SQLException {
        HResultSet resultSet = this.executeQuery(statement);
        statement.setResultSet(resultSet);
        return true;
    }

    public static class ShowTableResultSet
    extends ResultSetBase
    implements HResultSet {
        private final HTableDescriptor[] tables;
        private int rowIndex = -1;

        public ShowTableResultSet(Statement statement, HTableDescriptor[] tables) {
            super(statement);
            this.tables = tables;
            HResultSetMetaDataImpl metaData = new HResultSetMetaDataImpl();
            ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
            column.setColumnName("name");
            column.setColumnType(12);
            column.setColumnTypeName("VARCHAR");
            metaData.getColumns().add(column);
            column = new ResultSetMetaDataBase.ColumnMetaData();
            column.setColumnName("owner");
            column.setColumnType(12);
            column.setColumnTypeName("VARCHAR");
            metaData.getColumns().add(column);
            column = new ResultSetMetaDataBase.ColumnMetaData();
            column.setColumnName("familys");
            column.setColumnType(12);
            column.setColumnTypeName("VARCHAR");
            metaData.getColumns().add(column);
            column = new ResultSetMetaDataBase.ColumnMetaData();
            column.setColumnName("maxFileSize");
            column.setColumnType(-5);
            column.setColumnTypeName("long");
            metaData.getColumns().add(column);
            column = new ResultSetMetaDataBase.ColumnMetaData();
            column.setColumnName("memStoreFlushSize");
            column.setColumnType(-5);
            column.setColumnTypeName("long");
            metaData.getColumns().add(column);
            column = new ResultSetMetaDataBase.ColumnMetaData();
            column.setColumnName("regionSplitPolicyClassName");
            column.setColumnType(12);
            column.setColumnTypeName("VARCHAR");
            metaData.getColumns().add(column);
            this.metaData = metaData;
        }

        @Override
        public synchronized boolean next() throws SQLException {
            if (this.closed) {
                throw new SQLException();
            }
            if (this.rowIndex < this.tables.length - 1) {
                ++this.rowIndex;
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean previous() throws SQLException {
            if (this.closed) {
                throw new SQLException();
            }
            if (this.rowIndex > 0) {
                --this.rowIndex;
                return true;
            }
            return false;
        }

        @Override
        public String getString(String columnName) {
            return (String)this.getObject(columnName);
        }

        @Override
        public Object getObject(String columnName) {
            HTableDescriptor table = this.tables[this.rowIndex];
            if ("name".equals(columnName)) {
                return table.getNameAsString();
            }
            if ("owner".equals(columnName)) {
                return table.getOwnerString();
            }
            if ("familys".equals(columnName)) {
                StringBuffer buf = new StringBuffer();
                for (HColumnDescriptor column : table.getFamilies()) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append(column.getNameAsString());
                }
                return buf.toString();
            }
            if ("maxFileSize".equals(columnName)) {
                return table.getMaxFileSize();
            }
            if ("memStoreFlushSize".equals(columnName)) {
                return table.getMemStoreFlushSize();
            }
            if ("regionSplitPolicyClassName".equals(columnName)) {
                return table.getRegionSplitPolicyClassName();
            }
            return null;
        }

        @Override
        public int findColumn(String columnName) throws SQLException {
            HResultSetMetaDataImpl meta = (HResultSetMetaDataImpl)this.metaData;
            return meta.findColumn(columnName);
        }

        @Override
        public void updateObject(int columnIndex, Object x) throws SQLException {
        }

        @Override
        public HStatement getStatement() throws SQLException {
            return (HStatement)this.statement;
        }
    }
}

