/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.vocabulary;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.audio.asr.vocabulary.Vocabulary;
import com.alibaba.dashscope.audio.asr.vocabulary.VocabularyOperationType;
import com.alibaba.dashscope.audio.asr.vocabulary.VocabularyParam;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.google.gson.JsonArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VocabularyService {
    private static final Logger log = LoggerFactory.getLogger(VocabularyService.class);
    private final SynchronizeHalfDuplexApi<HalfDuplexServiceParam> syncApi;
    private final ApiServiceOption createServiceOptions;
    private static final String VOCABULARY_MODEL_NAME = "speech-biasing";
    private String apikey;
    private String lastRequestId;
    private String model;

    public VocabularyService(String apikey) {
        this.apikey = apikey;
        this.createServiceOptions = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).taskGroup("audio")).task("asr")).function("customization")).isAsyncTask(false)).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.createServiceOptions);
        this.model = VOCABULARY_MODEL_NAME;
    }

    public VocabularyService(String apikey, String model) {
        this.apikey = apikey;
        this.createServiceOptions = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).taskGroup("audio")).task("asr")).function("customization")).isAsyncTask(false)).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.createServiceOptions);
        this.model = model;
    }

    public Vocabulary createVocabulary(String targetModel, String prefix, JsonArray vocabulary) throws NoApiKeyException, InputRequiredException {
        return this.createVocabulary(targetModel, prefix, vocabulary, (VocabularyParam)((VocabularyParam.VocabularyParamBuilder)VocabularyParam.builder().model(this.model)).build());
    }

    public Vocabulary[] listVocabulary(String prefix) throws NoApiKeyException, InputRequiredException {
        return this.listVocabulary(prefix, 0, 10, (VocabularyParam)((VocabularyParam.VocabularyParamBuilder)VocabularyParam.builder().model(VOCABULARY_MODEL_NAME)).build());
    }

    public Vocabulary[] listVocabulary(String prefix, int pageIndex, int pageSize) throws NoApiKeyException, InputRequiredException {
        return this.listVocabulary(prefix, pageIndex, pageSize, (VocabularyParam)((VocabularyParam.VocabularyParamBuilder)VocabularyParam.builder().model(VOCABULARY_MODEL_NAME)).build());
    }

    public Vocabulary queryVocabulary(String vocabularyId) throws NoApiKeyException, InputRequiredException {
        return this.queryVocabulary(vocabularyId, (VocabularyParam)((VocabularyParam.VocabularyParamBuilder)VocabularyParam.builder().model(VOCABULARY_MODEL_NAME)).build());
    }

    public void updateVocabulary(String vocabularyId, JsonArray vocabulary) throws NoApiKeyException, InputRequiredException {
        this.updateVocabulary(vocabularyId, vocabulary, (VocabularyParam)((VocabularyParam.VocabularyParamBuilder)VocabularyParam.builder().model(VOCABULARY_MODEL_NAME)).build());
    }

    public void deleteVocabulary(String vocabularyId) throws NoApiKeyException, InputRequiredException {
        this.deleteVocabulary(vocabularyId, (VocabularyParam)((VocabularyParam.VocabularyParamBuilder)VocabularyParam.builder().model(VOCABULARY_MODEL_NAME)).build());
    }

    public Vocabulary createVocabulary(String targetModel, String prefix, JsonArray vocabulary, VocabularyParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VocabularyParam.builder().operationType(VocabularyOperationType.CREATE)).model(VOCABULARY_MODEL_NAME)).targetModel(targetModel)).prefix(prefix)).vocabulary(vocabulary)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VocabularyParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
        return Vocabulary.vocabularyFromCreateResult(dashScopeResult);
    }

    public Vocabulary[] listVocabulary(String prefix, int pageIndex, int pageSize, VocabularyParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VocabularyParam.builder().operationType(VocabularyOperationType.LIST)).model(VOCABULARY_MODEL_NAME)).prefix(prefix)).pageSize(pageSize)).pageIndex(pageIndex)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VocabularyParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
        return Vocabulary.vocabularyListFromListResult(dashScopeResult);
    }

    public Vocabulary queryVocabulary(String vocabularyId, VocabularyParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VocabularyParam.builder().operationType(VocabularyOperationType.QUERY)).model(VOCABULARY_MODEL_NAME)).vocabularyId(vocabularyId)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VocabularyParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
        return Vocabulary.vocabularyFromQueryResult(dashScopeResult);
    }

    public void updateVocabulary(String vocabularyId, JsonArray vocabulary, VocabularyParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VocabularyParam.builder().operationType(VocabularyOperationType.UPDATE)).model(VOCABULARY_MODEL_NAME)).vocabularyId(vocabularyId)).vocabulary(vocabulary)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VocabularyParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
    }

    public void deleteVocabulary(String vocabularyId, VocabularyParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VocabularyParam.VocabularyParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VocabularyParam.builder().operationType(VocabularyOperationType.DELETE)).model(VOCABULARY_MODEL_NAME)).vocabularyId(vocabularyId)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VocabularyParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }
}

