/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class DegradeRuleManager {
    private static final Map<String, Set<DegradeRule>> degradeRules = new ConcurrentHashMap<String, Set<DegradeRule>>();
    private static final RulePropertyListener LISTENER = new RulePropertyListener();
    private static SentinelProperty<List<DegradeRule>> currentProperty = new DynamicSentinelProperty<List<DegradeRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<DegradeRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        RulePropertyListener rulePropertyListener = LISTENER;
        synchronized (rulePropertyListener) {
            RecordLog.info("[DegradeRuleManager] Registering new property to degrade rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static void checkDegrade(ResourceWrapper resource, Context context, DefaultNode node, int count) throws BlockException {
        Set<DegradeRule> rules = degradeRules.get(resource.getName());
        if (rules == null) {
            return;
        }
        for (DegradeRule rule : rules) {
            if (rule.passCheck(context, node, count, new Object[0])) continue;
            throw new DegradeException(rule.getLimitApp(), rule);
        }
    }

    public static boolean hasConfig(String resource) {
        if (resource == null) {
            return false;
        }
        return degradeRules.containsKey(resource);
    }

    public static List<DegradeRule> getRules() {
        ArrayList<DegradeRule> rules = new ArrayList<DegradeRule>();
        for (Map.Entry<String, Set<DegradeRule>> entry : degradeRules.entrySet()) {
            rules.addAll((Collection<DegradeRule>)entry.getValue());
        }
        return rules;
    }

    public static void loadRules(List<DegradeRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.warn("[DegradeRuleManager] Unexpected error when loading degrade rules", e);
        }
    }

    public static boolean setRulesForResource(String resourceName, Set<DegradeRule> rules) {
        AssertUtil.notEmpty(resourceName, "resourceName cannot be empty");
        try {
            HashMap<String, Set<DegradeRule>> newRuleMap = new HashMap<String, Set<DegradeRule>>(degradeRules);
            if (rules == null) {
                newRuleMap.remove(resourceName);
            } else {
                HashSet<DegradeRule> newSet = new HashSet<DegradeRule>();
                for (DegradeRule rule : rules) {
                    if (!DegradeRuleManager.isValidRule(rule) || !resourceName.equals(rule.getResource())) continue;
                    newSet.add(rule);
                }
                newRuleMap.put(resourceName, newSet);
            }
            ArrayList allRules = new ArrayList();
            for (Set set : newRuleMap.values()) {
                allRules.addAll(set);
            }
            return currentProperty.updateValue(allRules);
        }
        catch (Throwable e) {
            RecordLog.warn("[DegradeRuleManager] Unexpected error when setting degrade rules for resource: " + resourceName, e);
            return false;
        }
    }

    public static boolean isValidRule(DegradeRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getTimeWindow() > 0;
        if (!baseValid) {
            return false;
        }
        int maxAllowedRt = Constants.TIME_DROP_VALVE;
        if (rule.getGrade() == 0) {
            if (rule.getRtSlowRequestAmount() <= 0) {
                return false;
            }
            if (rule.getCount() > (double)maxAllowedRt) {
                RecordLog.warn(String.format("[DegradeRuleManager] WARN: setting large RT threshold (%.1f ms) in RT mode will not take effect since it exceeds the max allowed value (%d ms)", rule.getCount(), maxAllowedRt), new Object[0]);
            }
        }
        if (rule.getGrade() == 1) {
            return rule.getCount() <= 1.0 && rule.getMinRequestAmount() > 0;
        }
        return true;
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class RulePropertyListener
    implements PropertyListener<List<DegradeRule>> {
        private RulePropertyListener() {
        }

        @Override
        public void configUpdate(List<DegradeRule> conf) {
            Map<String, Set<DegradeRule>> rules = this.loadDegradeConf(conf);
            if (rules != null) {
                degradeRules.clear();
                degradeRules.putAll(rules);
            }
            RecordLog.info("[DegradeRuleManager] Degrade rules received: " + degradeRules, new Object[0]);
        }

        @Override
        public void configLoad(List<DegradeRule> conf) {
            Map<String, Set<DegradeRule>> rules = this.loadDegradeConf(conf);
            if (rules != null) {
                degradeRules.clear();
                degradeRules.putAll(rules);
            }
            RecordLog.info("[DegradeRuleManager] Degrade rules loaded: " + degradeRules, new Object[0]);
        }

        private Map<String, Set<DegradeRule>> loadDegradeConf(List<DegradeRule> list) {
            ConcurrentHashMap<String, Set<DegradeRule>> newRuleMap = new ConcurrentHashMap<String, Set<DegradeRule>>();
            if (list == null || list.isEmpty()) {
                return newRuleMap;
            }
            for (DegradeRule rule : list) {
                String identity;
                HashSet<DegradeRule> ruleSet;
                if (!DegradeRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[DegradeRuleManager] Ignoring invalid degrade rule when loading new rules: " + rule, new Object[0]);
                    continue;
                }
                if (StringUtil.isBlank(rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                if ((ruleSet = (HashSet<DegradeRule>)newRuleMap.get(identity = rule.getResource())) == null) {
                    ruleSet = new HashSet<DegradeRule>();
                    newRuleMap.put(identity, ruleSet);
                }
                ruleSet.add(rule);
            }
            return newRuleMap;
        }
    }
}

