/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.annotation;

import com.alibaba.cloud.nacos.annotation.AbstractConfigChangeListener;
import com.alibaba.nacos.api.config.ConfigChangeEvent;
import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.Set;

public abstract class NacosPropertiesKeyListener
extends AbstractConfigChangeListener {
    Set<String> interestedKeys;
    Set<String> interestedKeyPrefixes;

    NacosPropertiesKeyListener(Object target) {
        super(target);
    }

    NacosPropertiesKeyListener(Object target, Set<String> interestedKeys) {
        this(target);
        this.interestedKeys = interestedKeys;
    }

    public NacosPropertiesKeyListener(Object target, Set<String> interestedKeys, Set<String> interestedKeyPrefixes) {
        this(target);
        this.interestedKeys = interestedKeys;
        this.interestedKeyPrefixes = interestedKeyPrefixes;
    }

    @Override
    public final void receiveConfigChange(ConfigChangeEvent event) {
        if (CollectionUtils.isNotEmpty(this.interestedKeys) || CollectionUtils.isNotEmpty(this.interestedKeyPrefixes)) {
            boolean foundInterested = false;
            block0: for (ConfigChangeItem changeItem : event.getChangeItems()) {
                if (this.interestedKeys != null && this.interestedKeys.contains(changeItem.getKey())) {
                    foundInterested = true;
                    break;
                }
                if (this.interestedKeyPrefixes == null) continue;
                for (String prefix : this.interestedKeyPrefixes) {
                    if (!changeItem.getKey().startsWith(prefix)) continue;
                    foundInterested = true;
                    continue block0;
                }
            }
            if (!foundInterested) {
                return;
            }
        }
        this.configChanged(event);
    }

    public String toString() {
        return "NacosPropertiesKeyListener{interestedKeys=" + this.interestedKeys + ", interestedKeyPrefixes=" + this.interestedKeyPrefixes + '}' + "@" + this.hashCode();
    }

    public abstract void configChanged(ConfigChangeEvent var1);
}

