/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExceptionComponent
extends PageComponent {
    public ExceptionComponent(PageComponentRegistry registry, String componentPath) {
        super(registry, componentPath);
    }

    public void visitTemplate(RequestHandlerContext context, Throwable exception) {
        this.getTemplate().accept(new ExceptionVisitor(context, exception));
    }

    private class ExceptionVisitor
    extends AbstractVisitor {
        private final List<Throwable> exceptions;
        private Throwable exception;
        private int exceptionId;
        private boolean defaultOpen;
        private StackTraceElement stackTraceElement;
        private String location;
        private boolean firstException;

        public ExceptionVisitor(RequestHandlerContext context, Throwable exception) {
            super(context, ExceptionComponent.this);
            this.firstException = true;
            this.exceptions = ExceptionUtil.getCauses(exception);
        }

        public void visitException(Template exceptionTemplate) {
            Iterator<Throwable> i = this.exceptions.iterator();
            while (i.hasNext()) {
                this.exception = i.next();
                ++this.exceptionId;
                this.defaultOpen = !i.hasNext();
                exceptionTemplate.accept(this);
                this.firstException = false;
            }
        }

        public void visitExceptionId() {
            ((PrintWriter)this.out()).print(this.exceptionId);
        }

        public void visitShowHideHandleImage(String openImage, String closeImage) {
            this.visitComponentUrl(this.defaultOpen ? openImage : closeImage);
        }

        public void visitCausedBy(Template causedByTemplate) {
            if (!this.firstException) {
                causedByTemplate.accept(this);
            }
        }

        public void visitExceptionType() {
            ((PrintWriter)this.out()).append(this.exception.getClass().getCanonicalName());
        }

        public void visitExceptionMessage() {
            if (StringUtil.isEmpty(this.exception.getMessage())) {
                ((PrintWriter)this.out()).append("No Message");
            } else {
                ((PrintWriter)this.out()).append(StringEscapeUtil.escapeHtml(this.exception.getMessage()));
            }
        }

        public void visitStackTrace(Template stackTraceElementTemplate) {
            StackTraceElement[] arr$ = this.exception.getStackTrace();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                StackTraceElement element;
                this.stackTraceElement = element = arr$[i$];
                this.location = ClassUtil.locateClass(this.stackTraceElement.getClassName());
                stackTraceElementTemplate.accept(this);
            }
        }

        public void visitStackTraceElement_Class() {
            ((PrintWriter)this.out()).append(this.stackTraceElement.getClassName());
        }

        public void visitStackTraceElement_PackageName() {
            String className = this.stackTraceElement.getClassName();
            int index = className.lastIndexOf(".");
            if (index > 0) {
                ((PrintWriter)this.out()).append(className.substring(0, index));
            } else {
                ((PrintWriter)this.out()).append("(default package)");
            }
        }

        public void visitStackTraceElement_SimpleClassName() {
            String className = this.stackTraceElement.getClassName();
            ((PrintWriter)this.out()).append(className.substring(className.lastIndexOf(".") + 1));
        }

        public void visitStackTraceElement_ClassLocation() {
            if (this.location != null) {
                ((PrintWriter)this.out()).append(this.location);
            } else {
                ((PrintWriter)this.out()).append("Could not locate class " + this.stackTraceElement.getClassName());
            }
        }

        public void visitStackTraceElement_ClassLocationShort() {
            Matcher m;
            String shortLocation = null;
            if (this.location != null && (m = Pattern.compile("[^/]+/?$").matcher(this.location)).find()) {
                shortLocation = m.group();
            }
            if (shortLocation != null) {
                ((PrintWriter)this.out()).append(shortLocation);
            } else {
                ((PrintWriter)this.out()).append("&lt;unknown location&gt;");
            }
        }

        public void visitStackTraceElement_Method() {
            ((PrintWriter)this.out()).append(this.stackTraceElement.getMethodName());
        }

        public void visitStackTraceElement_File() {
            ((PrintWriter)this.out()).append(this.stackTraceElement.getFileName());
        }

        public void visitStackTraceElement_Line() {
            ((PrintWriter)this.out()).print(this.stackTraceElement.getLineNumber());
        }
    }
}

