/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.store.cookie.impl;

import com.alibaba.citrus.service.requestcontext.session.SessionStore;
import com.alibaba.citrus.service.requestcontext.session.encoder.SessionEncoder;
import com.alibaba.citrus.service.requestcontext.session.encoder.impl.SerializationEncoder;
import com.alibaba.citrus.service.requestcontext.session.store.SessionStoreException;
import com.alibaba.citrus.service.requestcontext.session.store.cookie.AbstractCookieStore;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieStoreImpl
extends AbstractCookieStore {
    private static final String NAME_PATTERN_SUFFIX = "(\\d+)";
    private static final Integer MAX_LENGTH_DEFAULT = 3896;
    private static final Integer MAX_COUNT_DEFAULT = 5;
    private static final Boolean CHECKSUM_DEFAULT = false;
    private static final String CHECKSUM_SEPARATOR = "|";
    private static final int CHECKSUM_LENGTH = 15;
    private Pattern namePattern;
    private Integer maxLength;
    private Integer maxCount;
    private Boolean checksum;
    private String checksumName;
    private SessionEncoder[] encoders;

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }

    public void setEncoders(SessionEncoder[] encoders) {
        this.encoders = encoders;
    }

    @Override
    protected void init() {
        this.namePattern = Pattern.compile(this.getName() + NAME_PATTERN_SUFFIX);
        this.maxLength = ObjectUtil.defaultIfNull(this.maxLength, MAX_LENGTH_DEFAULT);
        this.maxCount = ObjectUtil.defaultIfNull(this.maxCount, MAX_COUNT_DEFAULT);
        this.checksum = ObjectUtil.defaultIfNull(this.checksum, CHECKSUM_DEFAULT);
        this.checksumName = this.getName() + "sum";
        if (ArrayUtil.isEmptyArray(this.encoders)) {
            this.encoders = new SessionEncoder[]{this.createDefaultSessionEncoder()};
        }
    }

    protected SessionEncoder createDefaultSessionEncoder() {
        SerializationEncoder encoder = new SerializationEncoder();
        try {
            encoder.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new SessionStoreException("Could not create default session encoder", e);
        }
        return encoder;
    }

    @Override
    public Iterable<String> getAttributeNames(String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        return state.attributes.keySet();
    }

    @Override
    public Object loadAttribute(String attrName, String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        return state.attributes.get(attrName);
    }

    @Override
    public void invaldiate(String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        if (!this.isSurvivesInInvalidating()) {
            state.attributes.clear();
        }
    }

    @Override
    public void commit(Map<String, Object> modifiedAttrs, String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        if (state.cookieCommitted) {
            return;
        }
        state.cookieCommitted = true;
        for (Map.Entry<String, Object> entry : modifiedAttrs.entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            if (attrValue == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Remove from session: {}", (Object)attrName);
                }
                state.attributes.remove(attrName);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Set to session: {} = {}", (Object)attrName, attrValue);
            }
            state.attributes.put(attrName, attrValue);
        }
        if (this.log.isDebugEnabled()) {
            for (String attrName : state.attributes.keySet()) {
                if (modifiedAttrs.containsKey(attrName)) continue;
                Object attrValue = state.attributes.get(attrName);
                this.log.debug("Left unchanged attribute: {} = {}", (Object)attrName, attrValue);
            }
        }
        String cookieState = null;
        if (!state.attributes.isEmpty()) {
            try {
                cookieState = this.encoders[0].encode(state.attributes, storeContext);
            }
            catch (Exception e) {
                this.log.warn("Failed to encode session state", (Throwable)e);
            }
        }
        if ((cookieState = StringUtil.trimToEmpty(cookieState)).length() > this.maxLength * this.maxCount) {
            this.log.warn("Cookie store full! length {} exceeds the max length: {} * {}.\n All session attributes will be LOST!", new Object[]{cookieState.length(), this.maxLength, this.maxCount});
        } else {
            StringBuilder checksumBuf = null;
            if (this.checksum.booleanValue()) {
                checksumBuf = new StringBuilder();
            }
            int beginOffset = 0;
            int i = 0;
            while (beginOffset < cookieState.length()) {
                int endOffset = Math.min(beginOffset + this.maxLength, cookieState.length());
                String cookieNameWithIndex = this.getName() + i;
                String cookieValue = cookieState.substring(beginOffset, endOffset);
                this.writeCookie(storeContext.getSessionRequestContext().getResponse(), cookieNameWithIndex, cookieValue);
                state.requestCookies.remove(cookieNameWithIndex);
                if (checksumBuf != null) {
                    if (checksumBuf.length() > 0) {
                        checksumBuf.append(CHECKSUM_SEPARATOR);
                    }
                    checksumBuf.append(StringUtil.substring(cookieValue, 0, 15));
                }
                beginOffset += this.maxLength.intValue();
                ++i;
            }
            for (String cookieName : state.requestCookies.keySet()) {
                this.writeCookie(storeContext.getSessionRequestContext().getResponse(), cookieName, null);
            }
            if (checksumBuf == null || checksumBuf.length() <= 0) {
                if (state.hasChecksum) {
                    this.writeCookie(storeContext.getSessionRequestContext().getResponse(), this.checksumName, null);
                }
            } else {
                this.writeCookie(storeContext.getSessionRequestContext().getResponse(), this.checksumName, checksumBuf.toString());
            }
        }
    }

    private State getState(SessionStore.StoreContext storeContext) {
        State state = (State)storeContext.getState();
        if (state == null) {
            state = new State();
            storeContext.setState(state);
        }
        this.ensureCookieLoading(state, storeContext.getSessionRequestContext().getRequest(), storeContext);
        return state;
    }

    private void ensureCookieLoading(State state, HttpServletRequest request, SessionStore.StoreContext storeContext) {
        if (state.cookieLoaded) {
            return;
        }
        state.cookieLoaded = true;
        CookiesInfo cookiesInfo = this.readCookies(request);
        state.requestCookies = cookiesInfo.requestCookies;
        state.hasChecksum = cookiesInfo.hasChecksum;
        state.checksumValid = this.validateCookies(cookiesInfo.cookieList, cookiesInfo.checksumList);
        state.mergedCookieValue = this.mergeCookies(cookiesInfo.cookieList, cookiesInfo.checksumList);
        state.attributes = this.decodeCookieValue(state.mergedCookieValue, storeContext);
    }

    private CookiesInfo readCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        CookiesInfo cookiesInfo = new CookiesInfo();
        cookiesInfo.requestCookies = CollectionUtil.createHashMap();
        cookiesInfo.cookieList = CollectionUtil.createArrayList(cookies.length);
        cookiesInfo.hasChecksum = false;
        CookiesInfo.access$1002(cookiesInfo, null);
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (ObjectUtil.isEquals(this.checksumName, cookieName)) {
                cookiesInfo.hasChecksum = true;
                CookiesInfo.access$1002(cookiesInfo, StringUtil.split(cookie.getValue(), "| "));
                continue;
            }
            Matcher matcher = this.namePattern.matcher(cookieName);
            if (!matcher.matches()) continue;
            int index = Integer.parseInt(matcher.group(1));
            String cookieValue = StringUtil.trimToNull(cookie.getValue());
            CookieInfo cookieInfo = new CookieInfo(index, cookieName, cookieValue);
            cookiesInfo.cookieList.add(cookieInfo);
            cookiesInfo.requestCookies.put(cookieName, cookieInfo);
        }
        Collections.sort(cookiesInfo.cookieList);
        if (this.log.isDebugEnabled()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("[%s] Loading cookies: %d cookies found", this.getStoreName(), cookiesInfo.cookieList.size());
            if (ArrayUtil.isEmptyArray(cookiesInfo.checksumList)) {
                if (this.checksum.booleanValue()) {
                    buf.append("\n No checksum cookie");
                }
            } else {
                buf.format("\n %s[expected cookies=%d]=%s", this.checksumName, cookiesInfo.checksumList.length, ObjectUtil.toString(cookiesInfo.checksumList));
            }
            for (CookieInfo cookieInfo : cookiesInfo.cookieList) {
                int length = 0;
                if (cookieInfo.value != null) {
                    length = cookieInfo.value.length();
                }
                buf.format("\n %s[length=%d]=%s", cookieInfo.name, length, cookieInfo.value);
            }
            this.log.debug(buf.toString());
        }
        return cookiesInfo;
    }

    private boolean validateCookies(List<CookieInfo> cookieList, String[] checksumList) {
        int checksumListSize = 0;
        int index = 0;
        if (checksumList != null) {
            checksumListSize = checksumList.length;
        }
        for (CookieInfo cookieInfo : cookieList) {
            if (cookieInfo.index != index || cookieInfo.value == null) break;
            if (index < checksumListSize && !cookieInfo.value.startsWith(checksumList[index])) {
                this.log.warn("{} does not match the checksum.  Expected prefix: {}[length={}], actually: {}[length={}]", new Object[]{cookieInfo.name, checksumList[index], checksumList[index].length(), cookieInfo.value, cookieInfo.value.length()});
                return false;
            }
            ++index;
        }
        if (checksumList != null && index != checksumListSize) {
            this.log.warn("Number of cookies {}* does not match checksum.  Expected cookies: {}, actually: {}", new Object[]{this.getName(), checksumListSize, index});
            return false;
        }
        return true;
    }

    private String mergeCookies(List<CookieInfo> cookieList, String[] checksumList) {
        StringBuilder buf = new StringBuilder();
        int index = 0;
        for (CookieInfo cookieInfo : cookieList) {
            if (cookieInfo.index != index || cookieInfo.value == null) break;
            buf.append(cookieInfo.value);
            ++index;
        }
        return StringUtil.trimToNull(buf.toString());
    }

    private Map<String, Object> decodeCookieValue(String cookieValue, SessionStore.StoreContext storeContext) {
        Map<Object, Object> attrs = null;
        if (cookieValue == null) {
            return CollectionUtil.createHashMap();
        }
        LinkedList<Exception> encoderExceptions = null;
        for (SessionEncoder encoder : this.encoders) {
            try {
                attrs = encoder.decode(cookieValue, storeContext);
                this.log.debug("Succeeded decoding cookieValues using {}", (Object)encoder);
                break;
            }
            catch (Exception e) {
                if (encoderExceptions == null) {
                    encoderExceptions = CollectionUtil.createLinkedList();
                }
                encoderExceptions.add(e);
                this.log.trace("Failure decoding cookieValues using {}: {}", (Object)encoder, (Object)e.getMessage());
            }
        }
        if (attrs == null) {
            attrs = CollectionUtil.createHashMap();
        }
        if (attrs.isEmpty() && encoderExceptions != null) {
            if (this.log.isWarnEnabled()) {
                ToStringBuilder buf = new ToStringBuilder();
                buf.append("Failed to decode cookie value: ").append(cookieValue);
                int i = 0;
                for (Exception e : encoderExceptions) {
                    buf.format("\n  Encoder #%d - %s threw %s", i + 1, this.encoders[i].getClass().getSimpleName(), e);
                }
                this.log.warn(buf.toString());
            }
        } else if (this.log.isDebugEnabled()) {
            int attrCount = attrs.size();
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Found %d attributes:", attrCount);
            if (!attrs.isEmpty()) {
                buf.append(new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true).appendAll(attrs));
            }
            this.log.debug(buf.toString());
        }
        return attrs;
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        super.toString(mb);
        mb.append("maxLength", this.maxLength);
        mb.append("maxCount", this.maxCount);
        mb.append("checksum", this.checksum);
        mb.append("encoders", this.encoders);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieInfo
    implements Comparable<CookieInfo> {
        public final int index;
        public final String name;
        public final String value;

        public CookieInfo(int index, String name, String value) {
            this.index = index;
            this.name = name;
            this.value = value;
        }

        @Override
        public int compareTo(CookieInfo o) {
            return this.index - o.index;
        }
    }

    private class State {
        private boolean cookieLoaded;
        private boolean cookieCommitted;
        private boolean hasChecksum;
        private Map<String, CookieInfo> requestCookies;
        private String mergedCookieValue;
        private Map<String, Object> attributes;
        private boolean checksumValid;

        private State() {
        }
    }

    private static class CookiesInfo {
        private Map<String, CookieInfo> requestCookies;
        private List<CookieInfo> cookieList;
        private String[] checksumList;
        private boolean hasChecksum;

        private CookiesInfo() {
        }

        static /* synthetic */ String[] access$1002(CookiesInfo x0, String[] x1) {
            x0.checksumList = x1;
            return x1;
        }
    }
}

