/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.convert;

import com.agentsflex.core.convert.BigDecimalConverter;
import com.agentsflex.core.convert.BigIntegerConverter;
import com.agentsflex.core.convert.BooleanConverter;
import com.agentsflex.core.convert.ByteArrayConverter;
import com.agentsflex.core.convert.ByteConverter;
import com.agentsflex.core.convert.DoubleConverter;
import com.agentsflex.core.convert.FloatConverter;
import com.agentsflex.core.convert.IConverter;
import com.agentsflex.core.convert.IntegerConverter;
import com.agentsflex.core.convert.LongConverter;
import com.agentsflex.core.convert.ShortConverter;
import com.agentsflex.core.util.ArrayUtil;
import com.agentsflex.core.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class ConvertService {
    private static final Map<Class<?>, IConverter<?>> CONVERTER_MAP = new HashMap();

    private static void register(IConverter<?> converter, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            CONVERTER_MAP.put(clazz, converter);
        }
    }

    public static Object convert(Object value, Class<?> toType) {
        if (value == null || value.getClass() == String.class && StringUtil.noText((String)value) && toType != String.class) {
            return null;
        }
        if (value.getClass().isAssignableFrom(toType)) {
            return value;
        }
        if (toType == Serializable.class && ArrayUtil.contains(value.getClass().getInterfaces(), Serializable.class)) {
            return value;
        }
        String valueString = value.toString().trim();
        if (valueString.isEmpty()) {
            return null;
        }
        IConverter<?> converter = CONVERTER_MAP.get(toType);
        if (converter != null) {
            return converter.convert(valueString);
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> paraClass) {
        if (paraClass == Integer.TYPE || paraClass == Long.TYPE || paraClass == Float.TYPE || paraClass == Double.TYPE) {
            return 0;
        }
        if (paraClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paraClass == Short.TYPE) {
            return (short)0;
        }
        if (paraClass == Byte.TYPE) {
            return (byte)0;
        }
        if (paraClass == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    static {
        ConvertService.register(new BooleanConverter(), Boolean.class, Boolean.TYPE);
        ConvertService.register(new IntegerConverter(), Integer.class, Integer.TYPE);
        ConvertService.register(new LongConverter(), Long.class, Long.TYPE);
        ConvertService.register(new DoubleConverter(), Double.class, Double.TYPE);
        ConvertService.register(new FloatConverter(), Float.class, Float.TYPE);
        ConvertService.register(new ShortConverter(), Short.class, Short.TYPE);
        ConvertService.register(new BigDecimalConverter(), BigDecimal.class);
        ConvertService.register(new BigIntegerConverter(), BigInteger.class);
        ConvertService.register(new ByteConverter(), Byte.TYPE);
        ConvertService.register(new ByteArrayConverter(), byte[].class);
    }
}

