/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.IngestPipelineParams;
import co.elastic.clients.elasticsearch.connector.UpdatePipelineResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdatePipelineRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final IngestPipelineParams pipeline;
    public static final JsonpDeserializer<UpdatePipelineRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdatePipelineRequest::setupUpdatePipelineRequestDeserializer);
    public static final Endpoint<UpdatePipelineRequest, UpdatePipelineResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdatePipelineRequest, UpdatePipelineResponse>("es/connector.update_pipeline", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_pipeline");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdatePipelineResponse._DESERIALIZER);

    private UpdatePipelineRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.pipeline = ApiTypeHelper.requireNonNull(builder.pipeline, this, "pipeline");
    }

    public static UpdatePipelineRequest of(Function<Builder, ObjectBuilder<UpdatePipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final IngestPipelineParams pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pipeline");
        this.pipeline.serialize(generator, mapper);
    }

    protected static void setupUpdatePipelineRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipeline, IngestPipelineParams._DESERIALIZER, "pipeline");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdatePipelineRequest> {
        private String connectorId;
        private IngestPipelineParams pipeline;

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder pipeline(IngestPipelineParams value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipeline(Function<IngestPipelineParams.Builder, ObjectBuilder<IngestPipelineParams>> fn) {
            return this.pipeline(fn.apply(new IngestPipelineParams.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            this._checkSingleUse();
            return new UpdatePipelineRequest(this);
        }
    }
}

