/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DissectProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String appendSeparator;
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final String pattern;
    public static final JsonpDeserializer<DissectProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DissectProcessor::setupDissectProcessorDeserializer);

    private DissectProcessor(Builder builder) {
        super(builder);
        this.appendSeparator = builder.appendSeparator;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
    }

    public static DissectProcessor of(Function<Builder, ObjectBuilder<DissectProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Dissect;
    }

    @Nullable
    public final String appendSeparator() {
        return this.appendSeparator;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.appendSeparator != null) {
            generator.writeKey("append_separator");
            generator.write(this.appendSeparator);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
    }

    protected static void setupDissectProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::appendSeparator, JsonpDeserializer.stringDeserializer(), "append_separator");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DissectProcessor> {
        @Nullable
        private String appendSeparator;
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private String pattern;

        public final Builder appendSeparator(@Nullable String value) {
            this.appendSeparator = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DissectProcessor build() {
            this._checkSingleUse();
            return new DissectProcessor(this);
        }
    }
}

