/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschUtil;
import cn.hutool.extra.ssh.Sftp;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class SftpFileStorage
implements FileStorage {
    private String host;
    private int port;
    private String user;
    private String password;
    private String privateKeyPath;
    private Charset charset;
    private long connectionTimeout;
    private String platform;
    private String domain;
    private String basePath;
    private String storagePath;

    public Sftp getClient() {
        Session session = null;
        try {
            if (StrUtil.isNotBlank((CharSequence)this.privateKeyPath)) {
                byte[] passphrase = StrUtil.isBlank((CharSequence)this.password) ? null : this.password.getBytes(StandardCharsets.UTF_8);
                JSch jsch = new JSch();
                byte[] privateKey = IoUtil.readBytes((InputStream)URLUtil.url((String)this.privateKeyPath).openStream());
                jsch.addIdentity(this.privateKeyPath, privateKey, null, passphrase);
                session = JschUtil.createSession((JSch)jsch, (String)this.host, (int)this.port, (String)this.user);
                session.connect((int)this.connectionTimeout);
            } else {
                session = JschUtil.openSession((String)this.host, (int)this.port, (String)this.user, (String)this.password, (int)((int)this.connectionTimeout));
            }
            return new Sftp(session, this.charset, this.connectionTimeout);
        }
        catch (Exception e) {
            JschUtil.close(session);
            throw new FileStorageRuntimeException("SFTP\u8fde\u63a5\u5931\u8d25\uff01platform\uff1a" + this.platform, e);
        }
    }

    @Override
    public void close() {
    }

    public String getAbsolutePath(String path) {
        return this.storagePath + path;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(FileInfo fileInfo) {
        try (Sftp client = this.getClient();){
            if (fileInfo.getThFilename() != null) {
                this.delFile(client, this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));
            }
            this.delFile(client, this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
            boolean bl = true;
            return bl;
        }
        catch (JschRuntimeException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public void delFile(Sftp client, String filename) {
        block2: {
            try {
                client.delFile(filename);
            }
            catch (JschRuntimeException e) {
                if (e.getCause() instanceof SftpException && ((SftpException)e.getCause()).id == 2) break block2;
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(FileInfo fileInfo) {
        try (Sftp client = this.getClient();){
            boolean bl = client.exist(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
            return bl;
        }
        catch (JschRuntimeException e) {
            throw new FileStorageRuntimeException("\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (Sftp client = this.getClient();
             InputStream in = client.getClient().get(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));){
            consumer.accept(in);
        }
        catch (JschRuntimeException | SftpException | IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (Sftp client = this.getClient();
             InputStream in = client.getClient().get(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()) + fileInfo.getThFilename());){
            consumer.accept(in);
        }
        catch (JschRuntimeException | SftpException | IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }
}

