/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.Retry;
import cn.kinyun.wework.sdk.entity.external.croptag.*;
import cn.kinyun.wework.sdk.exception.CrossBarrierException;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.Collection;
import java.util.List;

/**
 * Auto generate interface of ExternalTagApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface ExternalTagClient {

    /**
     * markTag
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     * @throws CrossBarrierException
     */
    @Retry
    void markTag(String corpId, MarkTagParams params) throws WeworkException, CrossBarrierException;

    /**
     * 异步调用markTag
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    @Retry
    String asyncMarkTag(String corpId, MarkTagParams params);

    /**
     * add
     *
     * @param corpId
     * @param params
     * @return AddCorpTagResp
     * @throws WeworkException
     */
    AddCorpTagResp add(String corpId, AddCorpTagParams params) throws WeworkException;

    /**
     * 异步调用add
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncAdd(String corpId, AddCorpTagParams params);

    /**
     * update
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     */
    void update(String corpId, UpdateCorpTagParams params) throws WeworkException;

    /**
     * 异步调用update
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncUpdate(String corpId, UpdateCorpTagParams params);

    /**
     * delete
     *
     * @param corpId
     * @param groupIds
     * @param tagIds
     * @throws WeworkException
     */
    void delete(String corpId, Collection<String> groupIds, Collection<String> tagIds) throws WeworkException;

    /**
     * 异步调用delete
     *
     * @param corpId
     * @param groupIds
     * @param tagIds
     * @return requestId
     */
    String asyncDelete(String corpId, Collection<String> groupIds, Collection<String> tagIds);

    /**
     * list
     *
     * @param corpId
     * @param groupIds
     * @param tagIds
     * @return List<CorpTagGroup>
     * @throws WeworkException
     */
    List<CorpTagGroup> list(String corpId, Collection<String> groupIds, Collection<String> tagIds) throws WeworkException;

}