/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.customeracquisition.*;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of CustomerAcquisitionApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2023/05/06
 */
public interface CustomerAcquisitionClient {

    /**
     * listLink
     *
     * @param corpId
     * @param limit
     * @param cursor
     * @return CustomerAcquisitionLinkList
     * @throws WeworkException
     */
    CustomerAcquisitionLinkList listLink(String corpId, Integer limit, String cursor) throws WeworkException;

    /**
     * getLink
     *
     * @param corpId
     * @param linkId
     * @return CustomerAcquisitionLinkDetail
     * @throws WeworkException
     */
    CustomerAcquisitionLinkDetail getLink(String corpId, String linkId) throws WeworkException;

    /**
     * createLink
     *
     * @param corpId
     * @param linkReq
     * @return CustomerAcquisitionLinkResp
     * @throws WeworkException
     */
    CustomerAcquisitionLinkResp createLink(String corpId, CustomerAcquisitionLinkReq linkReq) throws WeworkException;

    /**
     * updateLink
     *
     * @param corpId
     * @param linkReq
     * @throws WeworkException
     */
    void updateLink(String corpId, CustomerAcquisitionLinkReq linkReq) throws WeworkException;

    /**
     * 异步调用updateLink
     *
     * @param corpId
     * @param linkReq
     * @return requestId
     */
    String asyncUpdateLink(String corpId, CustomerAcquisitionLinkReq linkReq);

    /**
     * deleteLink
     *
     * @param corpId
     * @param linkId
     * @throws WeworkException
     */
    void deleteLink(String corpId, String linkId) throws WeworkException;

    /**
     * 异步调用deleteLink
     *
     * @param corpId
     * @param linkId
     * @return requestId
     */
    String asyncDeleteLink(String corpId, String linkId);

    /**
     * getLinkCustomer
     *
     * @param corpId
     * @param linkId
     * @param limit
     * @param cursor
     * @return CustomerAcquisitionContactList
     * @throws WeworkException
     */
    CustomerAcquisitionContactList getLinkCustomer(String corpId, String linkId, Integer limit, String cursor) throws WeworkException;

    /**
     * getQuota
     *
     * @param corpId
     * @return CustomerAcquisitionQuota
     * @throws WeworkException
     */
    CustomerAcquisitionQuota getQuota(String corpId) throws WeworkException;

}