/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.custmized.CustomizedAuthUrl;
import cn.kinyun.wework.sdk.entity.custmized.OpenExternalUserIds;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserIds;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;
import java.util.Map;

/**
 * Auto generate interface of CustomizedApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface CustomizedClient {

    /**
     * getCustomizedAuthUrl
     *
     * @param templateIds
     * @param state
     * @return CustomizedAuthUrl
     * @throws WeworkException
     */
    CustomizedAuthUrl getCustomizedAuthUrl(List<String> templateIds, String state) throws WeworkException;

    /**
     * getNewExternalUserId
     *
     * @param corpId
     * @param externalUserIds
     * @return OpenExternalUserIds
     * @throws WeworkException
     */
    OpenExternalUserIds getNewExternalUserId(String corpId, List<String> externalUserIds) throws WeworkException;

    /**
     * getNewChatExternalUserId
     *
     * @param corpId
     * @param chatId
     * @param externalUserIds
     * @return OpenExternalUserIds
     * @throws WeworkException
     */
    OpenExternalUserIds getNewChatExternalUserId(String corpId, String chatId, List<String> externalUserIds) throws WeworkException;

    /**
     * finishOpenidMigration
     *
     * @param corpId
     * @param agentId
     * @param openidTypes
     * @throws WeworkException
     */
    void finishOpenidMigration(String corpId, Integer agentId, List<Integer> openidTypes) throws WeworkException;

    /**
     * getOpenCorpId
     *
     * @param corpId
     * @return String
     * @throws WeworkException
     */
    String getOpenCorpId(String corpId) throws WeworkException;

    /**
     * getOpenUserIds
     *
     * @param corpId
     * @param userIds
     * @return OpenUserIds
     * @throws WeworkException
     */
    OpenUserIds getOpenUserIds(String corpId, List<String> userIds) throws WeworkException;

    /**
     * getOpenUserIdMap
     *
     * @param corpId
     * @param userIds
     * @return Map<String, String>
     * @throws WeworkException
     */
    Map<String, String> getOpenUserIdMap(String corpId, List<String> userIds) throws WeworkException;

    /**
     * getOpenUserId
     *
     * @param corpId
     * @param userId
     * @return String
     * @throws WeworkException
     */
    String getOpenUserId(String corpId, String userId) throws WeworkException;

}