/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.entity.chat;

import cn.kinyun.wework.sdk.entity.chat.msg.Agree;
import cn.kinyun.wework.sdk.entity.chat.msg.Calendar;
import cn.kinyun.wework.sdk.entity.chat.msg.Card;
import cn.kinyun.wework.sdk.entity.chat.msg.ChatRecord;
import cn.kinyun.wework.sdk.entity.chat.msg.Collect;
import cn.kinyun.wework.sdk.entity.chat.msg.Disagree;
import cn.kinyun.wework.sdk.entity.chat.msg.DocMsg;
import cn.kinyun.wework.sdk.entity.chat.msg.Emotion;
import cn.kinyun.wework.sdk.entity.chat.msg.File;
import cn.kinyun.wework.sdk.entity.chat.msg.Image;
import cn.kinyun.wework.sdk.entity.chat.msg.Info;
import cn.kinyun.wework.sdk.entity.chat.msg.Link;
import cn.kinyun.wework.sdk.entity.chat.msg.Location;
import cn.kinyun.wework.sdk.entity.chat.msg.Meeting;
import cn.kinyun.wework.sdk.entity.chat.msg.MeetingVoiceCall;
import cn.kinyun.wework.sdk.entity.chat.msg.Mixed;
import cn.kinyun.wework.sdk.entity.chat.msg.RedPacket;
import cn.kinyun.wework.sdk.entity.chat.msg.Revoke;
import cn.kinyun.wework.sdk.entity.chat.msg.SphFeed;
import cn.kinyun.wework.sdk.entity.chat.msg.Text;
import cn.kinyun.wework.sdk.entity.chat.msg.Todo;
import cn.kinyun.wework.sdk.entity.chat.msg.Video;
import cn.kinyun.wework.sdk.entity.chat.msg.Voice;
import cn.kinyun.wework.sdk.entity.chat.msg.VoipDocShare;
import cn.kinyun.wework.sdk.entity.chat.msg.Vote;
import cn.kinyun.wework.sdk.entity.chat.msg.Weapp;
import cn.kinyun.wework.sdk.enums.ChatAction;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ChatMsg
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXTERNAL = "external";
    public static final String CONVERSATION_JOIN = "$$";
    @JsonAlias(value={"msgid"})
    private String msgId;
    private String action;
    private String from;
    private List<String> tolist;
    @JsonAlias(value={"roomid"})
    private String roomId;
    @JsonAlias(value={"msgtime"})
    private Long msgTime;
    @JsonAlias(value={"msgtype"})
    private String msgType;
    private Long time;
    private Long updateTime;
    private Long seq;
    private String corpId;
    private Long bizId;
    private String conversationId;
    private Boolean isRevoked;
    private Integer talkerType;
    private Boolean externalContact;
    private String fileUrl;
    private String fileName;
    private String fileType;
    private String transcodeFileUrl;
    private Integer duration;
    private String user;
    private Text text;
    private Image image;
    private Revoke revoke;
    private Agree agree;
    private Disagree disagree;
    private Voice voice;
    private Video video;
    private Card card;
    private Location location;
    private Emotion emotion;
    private File file;
    private Link link;
    private Weapp weapp;
    @JsonAlias(value={"chatrecord"})
    private ChatRecord chatRecord;
    private Todo todo;
    private Vote vote;
    private Collect collect;
    @JsonAlias(value={"redpacket"})
    private RedPacket redPacket;
    private Meeting meeting;
    private DocMsg doc;
    private Info info;
    private Calendar calendar;
    private Mixed mixed;
    @JsonAlias(value={"voiceid"})
    private String voiceId;
    @JsonAlias(value={"meeting_voice_call"})
    private MeetingVoiceCall meetingVoiceCall;
    @JsonAlias(value={"voipid"})
    private String voipId;
    @JsonAlias(value={"voip_doc_share"})
    private VoipDocShare voipDocShare;
    @JsonAlias(value={"sphfeed"})
    private SphFeed sphfeed;
    private String encryptCorpId;
    private String encryptFormId;
    private String encryptToId;

    public static String getConversationId(String roomId, String fromId, String talkerId) {
        if (StringUtils.isBlank((CharSequence)roomId)) {
            return Lists.newArrayList((Object[])new String[]{fromId, talkerId}).stream().sorted().collect(Collectors.joining(CONVERSATION_JOIN));
        }
        return roomId;
    }

    public static String getConversationId(ChatMsg chatMsg) {
        if (!ChatAction.SEND.getValue().equals(chatMsg.getAction())) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)chatMsg.getRoomId()) && chatMsg.getTolist() != null && chatMsg.getTolist().size() > 0) {
            return Lists.newArrayList((Object[])new String[]{chatMsg.getFrom(), chatMsg.getTolist().get(0)}).stream().sorted().collect(Collectors.joining(CONVERSATION_JOIN));
        }
        return chatMsg.getRoomId();
    }

    public static int getTalkerTypeByConversationId(String conversationId) {
        if (conversationId.startsWith("wr") && conversationId.indexOf(CONVERSATION_JOIN) == -1) {
            return TalkerType.CHATROOM.getValue();
        }
        return TalkerType.CONTACT.getValue();
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getAction() {
        return this.action;
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getTolist() {
        return this.tolist;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public Long getMsgTime() {
        return this.msgTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public Long getTime() {
        return this.time;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Long getSeq() {
        return this.seq;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public Boolean getIsRevoked() {
        return this.isRevoked;
    }

    public Integer getTalkerType() {
        return this.talkerType;
    }

    public Boolean getExternalContact() {
        return this.externalContact;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getTranscodeFileUrl() {
        return this.transcodeFileUrl;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getUser() {
        return this.user;
    }

    public Text getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public Revoke getRevoke() {
        return this.revoke;
    }

    public Agree getAgree() {
        return this.agree;
    }

    public Disagree getDisagree() {
        return this.disagree;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Video getVideo() {
        return this.video;
    }

    public Card getCard() {
        return this.card;
    }

    public Location getLocation() {
        return this.location;
    }

    public Emotion getEmotion() {
        return this.emotion;
    }

    public File getFile() {
        return this.file;
    }

    public Link getLink() {
        return this.link;
    }

    public Weapp getWeapp() {
        return this.weapp;
    }

    public ChatRecord getChatRecord() {
        return this.chatRecord;
    }

    public Todo getTodo() {
        return this.todo;
    }

    public Vote getVote() {
        return this.vote;
    }

    public Collect getCollect() {
        return this.collect;
    }

    public RedPacket getRedPacket() {
        return this.redPacket;
    }

    public Meeting getMeeting() {
        return this.meeting;
    }

    public DocMsg getDoc() {
        return this.doc;
    }

    public Info getInfo() {
        return this.info;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Mixed getMixed() {
        return this.mixed;
    }

    public String getVoiceId() {
        return this.voiceId;
    }

    public MeetingVoiceCall getMeetingVoiceCall() {
        return this.meetingVoiceCall;
    }

    public String getVoipId() {
        return this.voipId;
    }

    public VoipDocShare getVoipDocShare() {
        return this.voipDocShare;
    }

    public SphFeed getSphfeed() {
        return this.sphfeed;
    }

    public String getEncryptCorpId() {
        return this.encryptCorpId;
    }

    public String getEncryptFormId() {
        return this.encryptFormId;
    }

    public String getEncryptToId() {
        return this.encryptToId;
    }

    @JsonAlias(value={"msgid"})
    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTolist(List<String> tolist) {
        this.tolist = tolist;
    }

    @JsonAlias(value={"roomid"})
    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    @JsonAlias(value={"msgtime"})
    public void setMsgTime(Long msgTime) {
        this.msgTime = msgTime;
    }

    @JsonAlias(value={"msgtype"})
    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setIsRevoked(Boolean isRevoked) {
        this.isRevoked = isRevoked;
    }

    public void setTalkerType(Integer talkerType) {
        this.talkerType = talkerType;
    }

    public void setExternalContact(Boolean externalContact) {
        this.externalContact = externalContact;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setTranscodeFileUrl(String transcodeFileUrl) {
        this.transcodeFileUrl = transcodeFileUrl;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setRevoke(Revoke revoke) {
        this.revoke = revoke;
    }

    public void setAgree(Agree agree) {
        this.agree = agree;
    }

    public void setDisagree(Disagree disagree) {
        this.disagree = disagree;
    }

    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setEmotion(Emotion emotion) {
        this.emotion = emotion;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setWeapp(Weapp weapp) {
        this.weapp = weapp;
    }

    @JsonAlias(value={"chatrecord"})
    public void setChatRecord(ChatRecord chatRecord) {
        this.chatRecord = chatRecord;
    }

    public void setTodo(Todo todo) {
        this.todo = todo;
    }

    public void setVote(Vote vote) {
        this.vote = vote;
    }

    public void setCollect(Collect collect) {
        this.collect = collect;
    }

    @JsonAlias(value={"redpacket"})
    public void setRedPacket(RedPacket redPacket) {
        this.redPacket = redPacket;
    }

    public void setMeeting(Meeting meeting) {
        this.meeting = meeting;
    }

    public void setDoc(DocMsg doc) {
        this.doc = doc;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setMixed(Mixed mixed) {
        this.mixed = mixed;
    }

    @JsonAlias(value={"voiceid"})
    public void setVoiceId(String voiceId) {
        this.voiceId = voiceId;
    }

    @JsonAlias(value={"meeting_voice_call"})
    public void setMeetingVoiceCall(MeetingVoiceCall meetingVoiceCall) {
        this.meetingVoiceCall = meetingVoiceCall;
    }

    @JsonAlias(value={"voipid"})
    public void setVoipId(String voipId) {
        this.voipId = voipId;
    }

    @JsonAlias(value={"voip_doc_share"})
    public void setVoipDocShare(VoipDocShare voipDocShare) {
        this.voipDocShare = voipDocShare;
    }

    @JsonAlias(value={"sphfeed"})
    public void setSphfeed(SphFeed sphfeed) {
        this.sphfeed = sphfeed;
    }

    public void setEncryptCorpId(String encryptCorpId) {
        this.encryptCorpId = encryptCorpId;
    }

    public void setEncryptFormId(String encryptFormId) {
        this.encryptFormId = encryptFormId;
    }

    public void setEncryptToId(String encryptToId) {
        this.encryptToId = encryptToId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMsg)) {
            return false;
        }
        ChatMsg other = (ChatMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$msgTime = this.getMsgTime();
        Long other$msgTime = other.getMsgTime();
        if (this$msgTime == null ? other$msgTime != null : !((Object)this$msgTime).equals(other$msgTime)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Long this$seq = this.getSeq();
        Long other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Boolean this$isRevoked = this.getIsRevoked();
        Boolean other$isRevoked = other.getIsRevoked();
        if (this$isRevoked == null ? other$isRevoked != null : !((Object)this$isRevoked).equals(other$isRevoked)) {
            return false;
        }
        Integer this$talkerType = this.getTalkerType();
        Integer other$talkerType = other.getTalkerType();
        if (this$talkerType == null ? other$talkerType != null : !((Object)this$talkerType).equals(other$talkerType)) {
            return false;
        }
        Boolean this$externalContact = this.getExternalContact();
        Boolean other$externalContact = other.getExternalContact();
        if (this$externalContact == null ? other$externalContact != null : !((Object)this$externalContact).equals(other$externalContact)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        List<String> this$tolist = this.getTolist();
        List<String> other$tolist = other.getTolist();
        if (this$tolist == null ? other$tolist != null : !((Object)this$tolist).equals(other$tolist)) {
            return false;
        }
        String this$roomId = this.getRoomId();
        String other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !this$roomId.equals(other$roomId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$fileUrl = this.getFileUrl();
        String other$fileUrl = other.getFileUrl();
        if (this$fileUrl == null ? other$fileUrl != null : !this$fileUrl.equals(other$fileUrl)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$transcodeFileUrl = this.getTranscodeFileUrl();
        String other$transcodeFileUrl = other.getTranscodeFileUrl();
        if (this$transcodeFileUrl == null ? other$transcodeFileUrl != null : !this$transcodeFileUrl.equals(other$transcodeFileUrl)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        Text this$text = this.getText();
        Text other$text = other.getText();
        if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
            return false;
        }
        Image this$image = this.getImage();
        Image other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        Revoke this$revoke = this.getRevoke();
        Revoke other$revoke = other.getRevoke();
        if (this$revoke == null ? other$revoke != null : !((Object)this$revoke).equals(other$revoke)) {
            return false;
        }
        Agree this$agree = this.getAgree();
        Agree other$agree = other.getAgree();
        if (this$agree == null ? other$agree != null : !((Object)this$agree).equals(other$agree)) {
            return false;
        }
        Disagree this$disagree = this.getDisagree();
        Disagree other$disagree = other.getDisagree();
        if (this$disagree == null ? other$disagree != null : !((Object)this$disagree).equals(other$disagree)) {
            return false;
        }
        Voice this$voice = this.getVoice();
        Voice other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !((Object)this$voice).equals(other$voice)) {
            return false;
        }
        Video this$video = this.getVideo();
        Video other$video = other.getVideo();
        if (this$video == null ? other$video != null : !((Object)this$video).equals(other$video)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Emotion this$emotion = this.getEmotion();
        Emotion other$emotion = other.getEmotion();
        if (this$emotion == null ? other$emotion != null : !((Object)this$emotion).equals(other$emotion)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        Weapp this$weapp = this.getWeapp();
        Weapp other$weapp = other.getWeapp();
        if (this$weapp == null ? other$weapp != null : !((Object)this$weapp).equals(other$weapp)) {
            return false;
        }
        ChatRecord this$chatRecord = this.getChatRecord();
        ChatRecord other$chatRecord = other.getChatRecord();
        if (this$chatRecord == null ? other$chatRecord != null : !((Object)this$chatRecord).equals(other$chatRecord)) {
            return false;
        }
        Todo this$todo = this.getTodo();
        Todo other$todo = other.getTodo();
        if (this$todo == null ? other$todo != null : !((Object)this$todo).equals(other$todo)) {
            return false;
        }
        Vote this$vote = this.getVote();
        Vote other$vote = other.getVote();
        if (this$vote == null ? other$vote != null : !((Object)this$vote).equals(other$vote)) {
            return false;
        }
        Collect this$collect = this.getCollect();
        Collect other$collect = other.getCollect();
        if (this$collect == null ? other$collect != null : !((Object)this$collect).equals(other$collect)) {
            return false;
        }
        RedPacket this$redPacket = this.getRedPacket();
        RedPacket other$redPacket = other.getRedPacket();
        if (this$redPacket == null ? other$redPacket != null : !((Object)this$redPacket).equals(other$redPacket)) {
            return false;
        }
        Meeting this$meeting = this.getMeeting();
        Meeting other$meeting = other.getMeeting();
        if (this$meeting == null ? other$meeting != null : !((Object)this$meeting).equals(other$meeting)) {
            return false;
        }
        DocMsg this$doc = this.getDoc();
        DocMsg other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Calendar this$calendar = this.getCalendar();
        Calendar other$calendar = other.getCalendar();
        if (this$calendar == null ? other$calendar != null : !((Object)this$calendar).equals(other$calendar)) {
            return false;
        }
        Mixed this$mixed = this.getMixed();
        Mixed other$mixed = other.getMixed();
        if (this$mixed == null ? other$mixed != null : !((Object)this$mixed).equals(other$mixed)) {
            return false;
        }
        String this$voiceId = this.getVoiceId();
        String other$voiceId = other.getVoiceId();
        if (this$voiceId == null ? other$voiceId != null : !this$voiceId.equals(other$voiceId)) {
            return false;
        }
        MeetingVoiceCall this$meetingVoiceCall = this.getMeetingVoiceCall();
        MeetingVoiceCall other$meetingVoiceCall = other.getMeetingVoiceCall();
        if (this$meetingVoiceCall == null ? other$meetingVoiceCall != null : !((Object)this$meetingVoiceCall).equals(other$meetingVoiceCall)) {
            return false;
        }
        String this$voipId = this.getVoipId();
        String other$voipId = other.getVoipId();
        if (this$voipId == null ? other$voipId != null : !this$voipId.equals(other$voipId)) {
            return false;
        }
        VoipDocShare this$voipDocShare = this.getVoipDocShare();
        VoipDocShare other$voipDocShare = other.getVoipDocShare();
        if (this$voipDocShare == null ? other$voipDocShare != null : !((Object)this$voipDocShare).equals(other$voipDocShare)) {
            return false;
        }
        SphFeed this$sphfeed = this.getSphfeed();
        SphFeed other$sphfeed = other.getSphfeed();
        if (this$sphfeed == null ? other$sphfeed != null : !((Object)this$sphfeed).equals(other$sphfeed)) {
            return false;
        }
        String this$encryptCorpId = this.getEncryptCorpId();
        String other$encryptCorpId = other.getEncryptCorpId();
        if (this$encryptCorpId == null ? other$encryptCorpId != null : !this$encryptCorpId.equals(other$encryptCorpId)) {
            return false;
        }
        String this$encryptFormId = this.getEncryptFormId();
        String other$encryptFormId = other.getEncryptFormId();
        if (this$encryptFormId == null ? other$encryptFormId != null : !this$encryptFormId.equals(other$encryptFormId)) {
            return false;
        }
        String this$encryptToId = this.getEncryptToId();
        String other$encryptToId = other.getEncryptToId();
        return !(this$encryptToId == null ? other$encryptToId != null : !this$encryptToId.equals(other$encryptToId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $msgTime = this.getMsgTime();
        result = result * 59 + ($msgTime == null ? 43 : ((Object)$msgTime).hashCode());
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Long $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Boolean $isRevoked = this.getIsRevoked();
        result = result * 59 + ($isRevoked == null ? 43 : ((Object)$isRevoked).hashCode());
        Integer $talkerType = this.getTalkerType();
        result = result * 59 + ($talkerType == null ? 43 : ((Object)$talkerType).hashCode());
        Boolean $externalContact = this.getExternalContact();
        result = result * 59 + ($externalContact == null ? 43 : ((Object)$externalContact).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        List<String> $tolist = this.getTolist();
        result = result * 59 + ($tolist == null ? 43 : ((Object)$tolist).hashCode());
        String $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : $roomId.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $fileUrl = this.getFileUrl();
        result = result * 59 + ($fileUrl == null ? 43 : $fileUrl.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $transcodeFileUrl = this.getTranscodeFileUrl();
        result = result * 59 + ($transcodeFileUrl == null ? 43 : $transcodeFileUrl.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        Text $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        Image $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        Revoke $revoke = this.getRevoke();
        result = result * 59 + ($revoke == null ? 43 : ((Object)$revoke).hashCode());
        Agree $agree = this.getAgree();
        result = result * 59 + ($agree == null ? 43 : ((Object)$agree).hashCode());
        Disagree $disagree = this.getDisagree();
        result = result * 59 + ($disagree == null ? 43 : ((Object)$disagree).hashCode());
        Voice $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : ((Object)$voice).hashCode());
        Video $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : ((Object)$video).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Emotion $emotion = this.getEmotion();
        result = result * 59 + ($emotion == null ? 43 : ((Object)$emotion).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        Weapp $weapp = this.getWeapp();
        result = result * 59 + ($weapp == null ? 43 : ((Object)$weapp).hashCode());
        ChatRecord $chatRecord = this.getChatRecord();
        result = result * 59 + ($chatRecord == null ? 43 : ((Object)$chatRecord).hashCode());
        Todo $todo = this.getTodo();
        result = result * 59 + ($todo == null ? 43 : ((Object)$todo).hashCode());
        Vote $vote = this.getVote();
        result = result * 59 + ($vote == null ? 43 : ((Object)$vote).hashCode());
        Collect $collect = this.getCollect();
        result = result * 59 + ($collect == null ? 43 : ((Object)$collect).hashCode());
        RedPacket $redPacket = this.getRedPacket();
        result = result * 59 + ($redPacket == null ? 43 : ((Object)$redPacket).hashCode());
        Meeting $meeting = this.getMeeting();
        result = result * 59 + ($meeting == null ? 43 : ((Object)$meeting).hashCode());
        DocMsg $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Calendar $calendar = this.getCalendar();
        result = result * 59 + ($calendar == null ? 43 : ((Object)$calendar).hashCode());
        Mixed $mixed = this.getMixed();
        result = result * 59 + ($mixed == null ? 43 : ((Object)$mixed).hashCode());
        String $voiceId = this.getVoiceId();
        result = result * 59 + ($voiceId == null ? 43 : $voiceId.hashCode());
        MeetingVoiceCall $meetingVoiceCall = this.getMeetingVoiceCall();
        result = result * 59 + ($meetingVoiceCall == null ? 43 : ((Object)$meetingVoiceCall).hashCode());
        String $voipId = this.getVoipId();
        result = result * 59 + ($voipId == null ? 43 : $voipId.hashCode());
        VoipDocShare $voipDocShare = this.getVoipDocShare();
        result = result * 59 + ($voipDocShare == null ? 43 : ((Object)$voipDocShare).hashCode());
        SphFeed $sphfeed = this.getSphfeed();
        result = result * 59 + ($sphfeed == null ? 43 : ((Object)$sphfeed).hashCode());
        String $encryptCorpId = this.getEncryptCorpId();
        result = result * 59 + ($encryptCorpId == null ? 43 : $encryptCorpId.hashCode());
        String $encryptFormId = this.getEncryptFormId();
        result = result * 59 + ($encryptFormId == null ? 43 : $encryptFormId.hashCode());
        String $encryptToId = this.getEncryptToId();
        result = result * 59 + ($encryptToId == null ? 43 : $encryptToId.hashCode());
        return result;
    }

    public String toString() {
        return "ChatMsg(msgId=" + this.getMsgId() + ", action=" + this.getAction() + ", from=" + this.getFrom() + ", tolist=" + this.getTolist() + ", roomId=" + this.getRoomId() + ", msgTime=" + this.getMsgTime() + ", msgType=" + this.getMsgType() + ", time=" + this.getTime() + ", updateTime=" + this.getUpdateTime() + ", seq=" + this.getSeq() + ", corpId=" + this.getCorpId() + ", bizId=" + this.getBizId() + ", conversationId=" + this.getConversationId() + ", isRevoked=" + this.getIsRevoked() + ", talkerType=" + this.getTalkerType() + ", externalContact=" + this.getExternalContact() + ", fileUrl=" + this.getFileUrl() + ", fileName=" + this.getFileName() + ", fileType=" + this.getFileType() + ", transcodeFileUrl=" + this.getTranscodeFileUrl() + ", duration=" + this.getDuration() + ", user=" + this.getUser() + ", text=" + this.getText() + ", image=" + this.getImage() + ", revoke=" + this.getRevoke() + ", agree=" + this.getAgree() + ", disagree=" + this.getDisagree() + ", voice=" + this.getVoice() + ", video=" + this.getVideo() + ", card=" + this.getCard() + ", location=" + this.getLocation() + ", emotion=" + this.getEmotion() + ", file=" + this.getFile() + ", link=" + this.getLink() + ", weapp=" + this.getWeapp() + ", chatRecord=" + this.getChatRecord() + ", todo=" + this.getTodo() + ", vote=" + this.getVote() + ", collect=" + this.getCollect() + ", redPacket=" + this.getRedPacket() + ", meeting=" + this.getMeeting() + ", doc=" + this.getDoc() + ", info=" + this.getInfo() + ", calendar=" + this.getCalendar() + ", mixed=" + this.getMixed() + ", voiceId=" + this.getVoiceId() + ", meetingVoiceCall=" + this.getMeetingVoiceCall() + ", voipId=" + this.getVoipId() + ", voipDocShare=" + this.getVoipDocShare() + ", sphfeed=" + this.getSphfeed() + ", encryptCorpId=" + this.getEncryptCorpId() + ", encryptFormId=" + this.getEncryptFormId() + ", encryptToId=" + this.getEncryptToId() + ")";
    }
}

