/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.exception;

/**
 * 会话存档SDK抛出异常。
 * 
 * @title FinanceSdkException
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
public class FinanceSdkException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    // 异常消息格式
    private static final String MESSAGE_FORMAT = "WeWorkFinanceSdk error(%d): %s";

    private final long ret;

    private final String msg;

    public FinanceSdkException(long ret, String msg) {
        super(String.format(MESSAGE_FORMAT, ret, msg));
        this.ret = ret;
        this.msg = msg;
    }

    public long getRet() {
        return ret;
    }

    public String getMsg() {
        return msg;
    }

}
