/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.enums;

/**
 * 通过会话存档拉去的聊天记录，包含如下的动作类型。
 * 
 * @title ChatAction
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 * @link https://work.weixin.qq.com/api/doc/90000/90135/91774
 */
public enum ChatAction {
    SEND("send", "发送消息"),
    
    RECALL("recall", "撤回消息"),
    
    SWITCH("switch", "切换企业日志");

    private final String value;

    private final String desc;

    ChatAction(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}