/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 
 * @title Privilege
 * @author yanmaoyuan
 * @date 2021年2月25日
 * @version 1.0
 */
@Data
public class Privilege implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 权限等级。
     * 1:通讯录基本信息只读
     * 2:通讯录全部信息只读
     * 3:通讯录全部信息读写
     * 4:单个基本信息只读
     * 5:通讯录全部信息只写
     */
    @JsonAlias("level")
    private Integer level;

    @JsonAlias("allow_party")
    private List<Integer> allowParty;

    @JsonAlias("allow_user")
    private List<String> allowUser;

    @JsonAlias("allow_tag")
    private List<Integer> allowTag;

    @JsonAlias("extra_party")
    private List<Integer> extraParty;

    @JsonAlias("extra_user")
    private List<String> extraUser;

    @JsonAlias("extra_tag")
    private List<Integer> extraTag;
}