/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title Agent
 * @author yanmaoyuan
 * @date 2021年2月25日
 * @version 1.0
 */
@Data
public class Agent implements Serializable {

    private static final long serialVersionUID = 1L;

    @JsonAlias("agentid")
    private Integer agentId;

    @JsonAlias("name")
    private String name;

    @JsonAlias("round_logo_url")
    private String roundLogoUrl;

    @JsonAlias("square_logo_url")
    private String squareLogoUrl;

    /**
     * 旧的多应用套件中的对应应用id，新开发者请忽略
     */
    @JsonAlias("appid")
    private String appId;

    /**
     * 授权模式，0为管理员授权；1为成员授权
     */
    @JsonAlias("auth_mode")
    private Integer authMode;

    /**
     * 是否为代开发自建应用
     */
    @JsonAlias("is_customized_app")
    private Boolean isCustomizedApp;

    @JsonAlias("privilege")
    private Privilege privilege;

    /**
     * 共享了应用的互联企业信息，仅当由互联的企业共享应用触发的安装时才返回
     */
    @JsonAlias("shared_from")
    private ShareFrom shareFrom;

}
