/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.provider;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title ProviderToken
 * @author yanmaoyuan
 * @date 2021年4月30日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class ProviderToken extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 服务商的access_token，最长为512字节。
     */
    @JsonAlias("provider_access_token")
    private String providerAccessToken;

    /**
     * provider_access_token有效期（秒）
     */
    @JsonAlias("expires_in")
    private Long expires;

}
