package cn.kinyun.wework.sdk.entity.oauth2;


import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class UserDetail extends ErrorCode {
    private static final long serialVersionUID = 1L;

    /**
     * 成员UserID
     */
    @JsonAlias("userid")
    private String userId;

    /**
     */
    private String name;

    /**
     * 性别。0表示未定义，1表示男性，2表示女性
     */
    private Integer gender;

    private String avatar;

    @JsonAlias("qr_code")
    private String qrCode;

    private String mobile;

    private String email;

    @JsonAlias("biz_mail")
    private String bizMail;

    private String address;
}
