package cn.kinyun.wework.sdk.entity.oa;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author sunwen
 */
@Data
public class SpInfo implements Serializable {


    private static final long serialVersionUID = 5815313369663478656L;
    /**
     * 审批编号
     */
    @JsonProperty("sp_no")
    private String spNo;

    /**
     * sp_name
     */
    @JsonProperty("sp_name")
    private String spName;

    /**
     * 申请单状态：1-审批中；2-已通过；3-已驳回；4-已撤销；6-通过后撤销；7-已删除；10-已支付
     */
    @JsonProperty("sp_status")
    private Integer spStatus;

    /**
     * 审批模板id。可在“获取审批申请详情”、“审批状态变化回调通知”中获得，也可在审批模板的模板编辑页面链接中获得。
     */
    @JsonProperty("template_id")
    private String templateId;

    /**
     * 审批申请提交时间,Unix时间戳
     */
    @JsonProperty("apply_time")
    private Integer applyTime;

    /**
     * 申请人信息
     */
    private Applyer applyer;

    /**
     * 审批流程信息，可能有多个审批节点
     */
    @JsonProperty("sp_record")
    private List<SpRecord> spRecords;
}
