package cn.kinyun.wework.sdk.entity.msg;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * media_id和pic_url只需填写一个，两者同时填写时使用media_id，二者不可同时为空。
 * 
 * @title Image
 * @author yanmaoyuan
 * @date 2021年4月28日
 * @version 1.0
 */
@Data
public class Image implements Serializable {
    private static final long serialVersionUID = 1L;
    /**s
     * 图片的media_id，可以通过素材管理接口获得
     */
    @JsonProperty("media_id")
    private String mediaId;

    /**
     * 图片的链接，仅可使用上传图片接口得到的链接
     * @see https://work.weixin.qq.com/api/doc/90000/90135/90256
     */
    @JsonProperty("pic_url")
    private String picUrl;
}
