package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class ListOrderReq implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业id，只支持加密的corpid。若指定corpid且corpid为服务商测试企业，则返回的订单列表为测试订单列表。否则只返回正式订单列表
     **/
    @JsonProperty("corpid")
    private String corpId;

    /**
     * 开始时间,下单时间。可不填。但是不能单独指定该字段，start_time跟end_time必须同时指定。
     **/
    @JsonProperty("start_time")
    private Long startTime;

    /**
     * 结束时间,下单时间。起始时间跟结束时间不能超过31天。可不填。但是不能单独指定该字段，start_time跟end_time必须同时指定。
     **/
    @JsonProperty("end_time")
    private Long endTime;

    /**
     * 用于分页查询的游标，字符串类型，由上一次调用返回，首次调用可不填
     **/
    private String cursor;

    /**
     * 返回的最大记录数，整型，最大值1000，默认值500
     **/
    private Integer limit;
}
