package cn.kinyun.wework.sdk.entity.external.massmsg;

import cn.kinyun.wework.sdk.entity.external.msg.Attachment;
import cn.kinyun.wework.sdk.entity.external.msg.Text;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class MassMsgParams implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 群发任务的类型，默认为single，表示发送给客户，group表示发送给客户群
     */
    @JsonProperty("chat_type")
    private String chatType;

    /**
     * 客户的外部联系人id列表，仅在chat_type为single时有效，不可与sender同时为空，最多可传入1万个客户
     */
    @JsonProperty("external_userid")
    private List<String> externalUserId;

    private String sender;

    private Text text;

    private List<Attachment> attachments;
}
