package cn.kinyun.wework.sdk.entity.external.massmsg;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 用于查询群发消息任务列表
 */
@Data
public class MassMsgListParams implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 群发任务的类型，默认为single，表示发送给客户，group表示发送给客户群
     * 必传
     */
    @JsonProperty("chat_type")
    private String chatType;

    /**
     * 群发任务的开始时间
     */
    @JsonProperty("start_time")
    private Long startTime;

    /**
     * 群发任务的结束时间
     * 群发任务记录的起止时间间隔不能超过1个月
     */
    @JsonProperty("end_time")
    private Long endTime;

    private String creator;

    /**
     * 创建人类型。0：企业发表 1：个人发表 2：所有，包括个人创建以及企业创建，默认情况下为所有类型
     */
    private Integer filterType = 2;

    /**
     * 默认是50
     */
    private Integer limit = 50;

    private String cursor;
}
