package cn.kinyun.wework.sdk.entity.external.customeracquisition;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 获客链接的可见范围
 *
 * 注意：user_list 和 department_list 不可同时为空
 *
 * @author yanmaoyuan
 * @date 2023/5/6
 */
@Data
public class CustomerAcquisitionRange implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty("user_list")
    private List<String> userList;// 此获客链接关联的userid列表，最多可关联100个
    @JsonProperty("department_list")
    private List<Integer> departmentList;// 此获客链接关联的部门id列表，部门覆盖总人数最多100个
}