package cn.kinyun.wework.sdk.entity.external.customeracquisition;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 获客链接
 *
 * @author yanmaoyuan
 * @date 2023/5/6
 */
@Data
public class CustomerAcquisitionLinkReq implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty("link_id")
    private String linkId;// 获客链接的id
    @JsonProperty("link_name")
    private String linkName; // 获客链接的名称
    private CustomerAcquisitionRange range;// 获客链接的可见范围
    @JsonProperty("skip_verify")
    private Boolean skipVerify = true;// 客户添加时是否无需验证，默认为true
}