package cn.kinyun.wework.sdk.entity.external.customeracquisition;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 获取获客链接列表
 *
 * 企业可通过此接口获取当前仍然有效的获客链接。
 * @author yanmaoyuan
 * @date 2023/5/6
 */
@Data
@EqualsAndHashCode(callSuper=true)
public class CustomerAcquisitionLinkList extends ErrorCode {
    private static final long serialVersionUID = 1L;
    @JsonAlias("link_id_list")
    private List<String> linkIdList;// link_id列表
    @JsonAlias("next_cursor")
    private String nextCursor;// 分页游标，在下次请求时填写以获取之后分页的记录
}