package cn.kinyun.wework.sdk.entity.external.croptag;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * <p>如果要向指定的标签组下添加标签，需要填写group_id参数；</p>
 * <p>如果要创建一个全新的标签组以及标签，则需要通过group_name参数指定新标签组名称；</p>
 * <p>如果填写的groupname已经存在，则会在此标签组下新建标签。</p>
 */
@Data
public class AddCorpTagParams implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("group_id")
    private String groupId;

    @JsonProperty("group_name")
    private String groupName;

    /**
     * 标签组排序的次序值，order值大的排序靠前。有效的值范围是[0, 2^32)
     */
    private Integer order;

    @JsonProperty("tag")
    private List<CorpTag> tagList;
}
