package cn.kinyun.wework.sdk.entity.external.contact;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 添加了客户的成员相关信息
 */
@Data
public class FollowUser implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 添加了此外部联系人的企业成员userid
     */
    @JsonProperty("userid")
    private String userId;

    /**
     * 成员给客户的备注
     */
    private String remark;

    private String description;

    /**
     * 单位秒
     */
    @JsonProperty("createtime")
    private Long createTime;

    /**
     * 标签
     */
    private List<Tag> tags;

    /**
     * 该成员对此客户备注的企业名称
     */
    @JsonProperty("remark_corp_name")
    private String remarkCorpName;

    /**
     * 该成员对此客户备注的手机号码
     */
    @JsonProperty("remark_mobiles")
    private List<String> remarkMobiles;

    @JsonProperty("add_way")
    private Integer addWay;

    @JsonProperty("oper_userid")
    private String operUserId;

    private String state;

}
