package cn.kinyun.wework.sdk.entity.external.contact;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class ExternalContactRemark implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 企业成员的userid
     * 必传
     */
    @JsonProperty("userid")
    private String userId;

    /**
     * 外部联系人userid
     * 必传
     */
    @JsonProperty("external_userid")
    private String externalUserId;

    /**
     * 此用户对外部联系人的备注，最多20个字符
     */
    private String remark;

    private String description;

    @JsonProperty("remark_company")
    private String remarkCompany;

    @JsonProperty("remark_mobiles")
    private List<String> remarkMobiles;

    @JsonProperty("remark_pic_mediaid")
    private String remarkPicMediaId;

}
