/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import java.io.Serializable;

import lombok.Data;

/**
 * @title Location
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Location implements Serializable {
    
    private static final long serialVersionUID = 1L;

    /**
     * 经度，单位double
     */
    private Double longitude;

    /**
     * 纬度，单位double
     */
    private Double latitude;

    /**
     * 地址信息。String类型
     */
    private String address;

    /**
     * 位置信息的title。String类型
     */
    private String title;

    /**
     * 缩放比例。Uint32类型
     */
    private Integer zoom;
}
