/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title DocMsg
 * @author yanmaoyuan
 * @date 2021年3月19日
 * @version 1.0
 */
@Data
public class DocMsg implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 在线文档名称
     */
    private String title;

    /**
     * 在线文档链接
     */
    @JsonAlias("link_url")
    private String linkUrl;

    /**
     * 在线文档创建者。本企业成员创建为userid；外部企业成员创建为external_userid
     */
    @JsonAlias("doc_creator")
    private String docCreator;
}
