/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title Collect
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Collect implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 填表消息所在的群名称。String类型
     */
    @JsonAlias("room_name")
    private String roomName;

    /**
     * 创建者在群中的名字。String类型
     */
    private String creator;

    /**
     * 创建的时间。String类型
     */
    @JsonAlias("create_time")
    private String createTime;

    /**
     * 表名。String类型
     */
    private String title;

    /**
     * 表内容。
     */
    private List<CollectItem> details;
}
