/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title ChatItem
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class ChatItem implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 每条聊天记录的具体消息类型：ChatRecordText/ ChatRecordFile/ ChatRecordImage/ ChatRecordVideo/ ChatRecordLink/ ChatRecordLocation/ ChatRecordMixed ….
     */
    private String type;

    /**
     * 消息内容。Json串，内容为对应类型的json。String类型
     */
    private String content;

    /**
     * 消息时间，utc时间，单位秒。
     */
    @JsonAlias("msgtime")
    private Long msgTime;

    /**
     * 是否来自群会话。Bool类型
     */
    @JsonAlias("from_chatroom")
    private Boolean fromChatroom;
}
