package cn.kinyun.wework.sdk.crypt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * SHA1 class
 *
 * 计算公众平台的消息签名接口.
 */
public final class SHA1 {

    private SHA1() {}

    // 十六进制数
    private static final char[] HEX_DIGITS =
            { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

    /**
     * 用SHA1算法生成安全签名
     * 
     * @param token 票据
     * @param timestamp 时间戳
     * @param nonce 随机字符串
     * @param encrypt 密文
     * @return 安全签名
     * @throws AesException
     */
    public static String getSHA1(String token, String timestamp, String nonce, String encrypt) throws AesException {
        String[] array = new String[] { token, timestamp, nonce, encrypt };
        StringBuilder sb = new StringBuilder();
        // 字符串排序
        Arrays.sort(array);
        for (int i = 0; i < 4; i++) {
            sb.append(array[i]);
        }
        String str = sb.toString();

        return sha1(str);
    }

    /**
     * 生成SHA1签名
     * 
     * @param str
     * @return
     * @throws AesException
     */
    public static String sha1(String str) throws AesException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            digest = md.digest();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new AesException(AesException.COMPUTE_SIGNATURE_ERROR);
        }

        // 把密文转换成十六进制的字符串形式
        return toHexStr(digest);
    }

    // 把密文转换成十六进制的字符串形式
    public static String toHexStr(byte[] digest) {
        char[] value = new char[digest.length * 2];
        for (int i = 0, idx = 0; i < digest.length; i++, idx += 2) {
            value[idx] = (HEX_DIGITS[(digest[i] >> 4) & 0x0F]); // 前四位
            value[idx + 1] = (HEX_DIGITS[digest[i] & 0x0F]); // 后四位
        }
        return new String(value);
    }
}
