package cn.kinyun.wework.sdk.callback.suite.external;


import cn.kinyun.wework.sdk.callback.suite.BaseSuiteEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 删除企业客户事件
 * ChangeType: transfer_fail
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class TransferFail extends BaseSuiteEvent {

    private static final long serialVersionUID = 1L;

    /**
     * 企业服务人员的UserID
     */
    @JacksonXmlProperty(localName = "UserID")
    private String userId;

    /**
     * 外部联系人的userid，注意不是企业成员的帐号
     */
    @JacksonXmlProperty(localName = "ExternalUserID")
    private String externalUserId;

    /**
     * 客户接替失败原因
     */
    @JacksonXmlProperty(localName = "FailReason")
    private String failReason;
}
