package cn.kinyun.wework.sdk.callback.suite.contact;

import cn.kinyun.wework.sdk.callback.suite.BaseSuiteEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 删除成员事件
 * 
 * ChangeType   固定为delete_user
 * 
 * @title DeleteUser
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/92654
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DeleteUser extends BaseSuiteEvent {
    private static final long serialVersionUID = 1L;

    /**
     * 	变更信息的成员UserID
     */
    @JacksonXmlProperty(localName = "UserID")
    private String userId;

    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的OpenUserID是相同的，最多64个字节。
     */
    @JacksonXmlProperty(localName = "OpenUserID")
    private String openUserId;
}
