/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite.auth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 推送suite_ticket
 * 
 * <p>企业微信服务器会定时（每十分钟）推送ticket。ticket会实时变更，并用于后续接口的调用。</p>
 * <p>若开发者想立即获得ticket推送值，可登录服务商平台，在第三方应用详情-回调配置，手动刷新ticket推送。</p>
 * 
 * @title SuiteTicket
 * @author yanmaoyuan
 * @date 2021年2月19日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class SuiteTicket implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 第三方应用的SuiteId
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 消息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * Ticket内容，最长为512字节
     */
    @JacksonXmlProperty(localName = "SuiteTicket")
    private String suiteTicket;
}
