/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite.auth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 变更授权通知
 * 
 * <p>当授权方（即授权企业）在企业微信管理端的授权管理中，修改了对应用的授权后，企业微信服务器推送变更授权通知。</p>
 * <p>服务商接收到变更通知之后，需自行调用获取企业授权信息进行授权内容变更比对。</p>
 * 
 * @title ChangeAuth
 * @author yanmaoyuan
 * @date 2021年2月19日
 * @version 1.0
 */
@Data
public class ChangeAuth implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 第三方应用的SuiteId
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 消息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * 授权方的corpid
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;

    /**
     * 构造授权链接指定的state参数
     */
    @JacksonXmlProperty(localName = "State")
    private String state;
}
