/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 授权成功通知
 * 
 * InfoType: share_agent_change
 * 
 * <pre>
 * 本事件触发时机为：
 * 
 * 1. 集团企业把第三方应用共享给下属企业使用
 * 2. 集团企业把下属企业从共享的第三方应用中移除
 * </pre>
 * 
 * @title ShareAgentChange
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/93373
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class ShareAgentChange implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 第三方应用的SuiteId
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 消息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * 第三方应用appid
     */
    @JacksonXmlProperty(localName = "AppId")
    private String appId;

    /**
     * 上级企业corpid
     */
    @JacksonXmlProperty(localName = "CorpId")
    private String corpId;

    /**
     * 上级企业应用id
     */
    @JacksonXmlProperty(localName = "AgentId")
    private String agentId;
}