/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.provider;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 异步任务完成通知
 * 
 * InfoType 事件类型，batch_job_result，通讯录导出完成回调
 * 
 * @title BatchJobResult
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/91875
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BatchJobResult implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 服务商corpid
     */
    @JacksonXmlProperty(localName = "ServiceCorpId")
    private String serviceCorpId;

    /**
     * 消息的类型，此时固定为event
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 企业corpid
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;

    /**
     * 回调事件的时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    @JacksonXmlProperty(localName = "BatchJob")
    private BatchJob batchJob;

    @Data
    public static class BatchJob implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 任务id,最大长度为64字符
         */
        @JacksonXmlProperty(localName = "JobId")
        private String jobId;

        /**
         * 任务类型，目前有contact_id_translate
         */
        @JacksonXmlProperty(localName = "JobType")
        private String jobType;
    }
}
