package cn.kinyun.wework.sdk.callback.license;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: lwl
 * @date: 2023/5/18
 * @description: 接口许可失效通知
 *
 * @link: https://developer.work.weixin.qq.com/document/path/95805
 **/
@Data
@JacksonXmlRootElement(localName = "xml")
public class RefundResultEvent implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 服务商CorpID
     */
    @JacksonXmlProperty(localName = "ServiceCorpId")
    private String serviceCorpId;

    /**
     * 事件类型，此时固定为license_refund
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 客户企业CorpID
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;

    /**
     * 订单号
     */
    @JacksonXmlProperty(localName = "OrderId")
    private String orderId;

    /**
     * 订单状态，1:退款成功，2:退款被拒绝。
     */
    @JacksonXmlProperty(localName = "OrderStatus")
    private Integer orderStatus;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timeStamp;

}
