package cn.kinyun.wework.sdk.callback.corp.contact;

import cn.kinyun.wework.sdk.callback.corp.BaseCorpEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 
 * @title UpdateTag
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90000/90135/90972
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UpdateTag extends BaseCorpEvent {

    private static final long serialVersionUID = 1L;

    @JacksonXmlProperty(localName = "TagId")
    private String tagId;

    /**
     * 标签中新增的成员userid列表，用逗号分隔
     */
    @JacksonXmlProperty(localName = "AddUserItems")
    private String addUserItems;

    /**
     * 标签中删除的成员userid列表，用逗号分隔
     */
    @JacksonXmlProperty(localName = "DelUserItems")
    private String delUserItems;

    /**
     * 标签中新增的部门id列表，用逗号分隔
     */
    @JacksonXmlProperty(localName = "AddPartyItems")
    private String addPartyItems;

    /**
     * 标签中删除的部门id列表，用逗号分隔
     */
    @JacksonXmlProperty(localName = "DelPartyItems")
    private String delPartyItems;
}
