/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.corp.contact;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 异步任务完成通知
 * 
 * Event    事件类型：batch_job_result
 * 
 * @title BatchJobResult
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90000/90135/90973
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BatchJobResult implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业微信CorpID
     */
    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    /**
     * 此事件该值固定为sys，表示该消息由系统生成
     */
    @JacksonXmlProperty(localName = "FromUserName")
    private String fromUserName;

    /**
     * 消息创建时间
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private Long createTime;

    /**
     * 消息的类型，此时固定为event
     */
    @JacksonXmlProperty(localName = "MsgType")
    private String msgType;

    /**
     * 事件的类型，此时固定为change_contact
     */
    @JacksonXmlProperty(localName = "Event")
    private String event;

    @JacksonXmlProperty(localName = "BatchJob")
    private BatchJob batchJob;

    @Data
    public static class BatchJob implements Serializable {
        private static final long serialVersionUID = 1L;

        @JacksonXmlProperty(localName = "JobId")
        private String jobId;

        @JacksonXmlProperty(localName = "JobType")
        private String jobType;

        @JacksonXmlProperty(localName = "ErrCode")
        private Integer errCode;

        @JacksonXmlProperty(localName = "ErrMsg")
        private String errMsg;
    }
}
