package cn.kinyun.wework.sdk.callback.agent.msg;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentMsg;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 语音消息
 * msgType voice
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VoiceMsg extends BaseAgentMsg {
    private static final long serialVersionUID = 1L;

    /**
     * 语音媒体文件id，可以调用获取媒体文件接口拉取数据，仅三天内有效
     */
    @JacksonXmlProperty(localName = "MediaId")
    private String mediaId;

    /**
     * 语音格式，如amr，speex等
     */
    @JacksonXmlProperty(localName = "Format")
    private String format;
}
