package cn.kinyun.wework.sdk.callback.agent.msg;


import cn.kinyun.wework.sdk.callback.agent.BaseAgentMsg;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 位置消息
 * msgType location
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class LocationMsg extends BaseAgentMsg {
    private static final long serialVersionUID = 1L;

    /**
     * 地理位置纬度
     */
    @JacksonXmlProperty(localName = "Location_X")
    private String locationX;

    /**
     * 地理位置经度
     */
    @JacksonXmlProperty(localName = "Location_Y")
    private String locationY;

    /**
     * 地图缩放大小
     */
    @JacksonXmlProperty(localName = "Scale")
    private Integer scale;

    /**
     * 地理位置信息
     */
    @JacksonXmlProperty(localName = "Label")
    private String label;

    /**
     * app类型，在企业微信固定返回wxwork，在微信不返回该字段
     */
    @JacksonXmlProperty(localName = "AppType")
    private String appType;
}
