package cn.kinyun.wework.sdk.api.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author sunwen
 */
@Data
public class ApplyEventReq {

    /**
     * 申请人weworkUserId
     */
    @JsonProperty("creator_userid")
    private String creatorUserId;

    /**
     * 模板id
     */
    @JsonProperty("template_id")
    private String templateId;

    /**
     * 审批人模式：0-通过接口指定审批人、抄送人（此时approver、notifyer等参数可用
     * 1-使用此模板在管理后台设置的审批流程
     */
    @JsonProperty("use_template_approver")
    private Integer useTemplateApprover;

    /**
     * 审批流程中各个节点的审批人信息
     */
    @JsonProperty("approver")
    private List<NodeApprover> nodeApprover;

    /**
     * 抄送人节点userid列表，仅use_template_approver为0时生效
     */
    private List<String> notifyer;

    /**
     * 抄送方式：1-提单时抄送（默认值）； 2-单据通过后抄送；3-提单和单据通过后抄送。
     * 仅use_template_approver为0时生效
     */
    @JsonProperty("notify_type")
    private Integer notifyType;

    /**
     * 审批申请数据，可定义审批申请中各个控件的值
     */
    @JsonProperty("apply_data")
    private ApplyData applyData;
}
