/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.enums;

/**
 * 授权类型：0 正式授权， 1 测试授权。 默认值为0。注意，请确保应用在正式发布后的授权类型为“正式授权”
 * 
 * @title SuiteAuthType
 * @author yanmaoyuan
 * @date 2021年2月24日
 * @version 1.0
 * @link https://open.work.weixin.qq.com/api/doc/90001/90143/90602
 */
public enum SuiteAuthType {

    PROD(0, "正式"),
    TEST(1, "测试");

    private final int value;
    private final String desc;

    SuiteAuthType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
